import { IAnimatorConfiguration } from './IConfig';
import { PropertyAnimator } from '../PropertyAnimator';

export class OffsetConfig implements IAnimatorConfiguration {
    configure(animator: PropertyAnimator, st: ScreenTransform) {
        animator.setupAnimation(() => st.offsets.getCenter(),
            (value) => {
                st.offsets.setCenter(value as vec2);
            },
            vec2.lerp);
    }
}
